/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm8260.DecoderException;
import ibm.nways.jdm8260.MibInfo;
import ibm.nways.jdm8260.MibValue;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Hashtable;

public final class SstDecoder {
    public static final int IUB_ASN_TYPE_UNSET = 0;
    public static final int IUB_ASN_BOOLEAN = 1;
    public static final int IUB_ASN_INTEGER = 2;
    public static final int IUB_ASN_U_INTEGER = 7;
    public static final int IUB_ASN_BIT_STR = 3;
    public static final int IUB_ASN_OCTET_STR = 4;
    public static final int IUB_ASN_NULL = 5;
    public static final int IUB_ASN_OBJECT_ID = 6;
    public static final int IUB_ASN_SEQUENCE = 48;
    public static final int IUB_ASN_IPADDRESS = 64;
    public static final int IUB_ASN_TIMETICKS = 67;
    private static final boolean debugOIDConversion = false;
    private static final boolean debugDecodeItem = false;
    private static final boolean debugDecodeLength = false;
    private static final boolean debugDecodeSuffix = true;
    private static final boolean debugDecodeValue = true;
    private boolean _8250_module_on_8260 = false;
    private boolean _8250_modTable = false;
    private byte[] values;
    private MibInfo mibInfo;
    protected static final Hashtable mappingTable = new Hashtable();
    protected static final String IP_STR = "IP";
    protected static final String DS_STR = "DS";
    static /* synthetic */ Class class$ibm$nways$jdm8260$SstDecoder;

    protected void finalize() throws Throwable {
        this.mibInfo = null;
        this.values = null;
    }

    public final void setMibInfo(MibInfo mibInfo) {
        this.mibInfo = mibInfo;
    }

    public final boolean decode(byte[] byArray, int n, int n2) {
        String string = "decode";
        if (byArray == null) {
            return false;
        }
        if (byArray.length == 0) {
            return false;
        }
        this._8250_module_on_8260 = false;
        if (RAS.isEnabled(19, 28)) {
            RAS.enter(19, 28, this, string);
        }
        this.values = byArray;
        boolean bl = true;
        int n3 = 0;
        try {
            DecodeRetValue decodeRetValue = this.decodeItem(n3, 48);
            n3 = decodeRetValue.itemDataIndex;
            decodeRetValue = this.decodeItem(n3, 67);
            n3 = decodeRetValue.nextItemIndex;
            decodeRetValue = this.decodeItem(n3, 48);
            int n4 = decodeRetValue.itemDataLength;
            n3 = decodeRetValue.itemDataIndex;
            while (n4 > 0) {
                decodeRetValue = this.decodeContainment(n3);
                n4 -= decodeRetValue.itemLength;
                n3 = decodeRetValue.nextItemIndex;
            }
        }
        catch (Exception exception) {
            bl = false;
            RAS.logException(19, 28, this, string, exception);
        }
        this.values = null;
        if (RAS.isEnabled(19, 28)) {
            RAS.exit(19, 28, this, string);
        }
        return bl;
    }

    private final DecodeRetValue decodeItem(int n, int n2) throws DecoderException {
        String string = "decodeItem";
        DecodeRetValue decodeRetValue = this.decodeLength(n + 1, this.values[n] & 0xFF);
        DecodeRetValue decodeRetValue2 = new DecodeRetValue();
        decodeRetValue2.itemDataLength = decodeRetValue.itemLength;
        decodeRetValue2.itemLength = decodeRetValue.itemDataLength + decodeRetValue.itemLength + 1;
        decodeRetValue2.itemDataIndex = n + 1 + decodeRetValue.itemDataLength;
        decodeRetValue2.nextItemIndex = n + decodeRetValue2.itemLength;
        if ((this.values[n] & 0xFF) != n2) {
            throw new DecoderException("Mismatched syntax. Expected " + n2 + " and found " + (this.values[n] & 0xFF) + " at pos. " + n);
        }
        return decodeRetValue2;
    }

    private final DecodeRetValue decodeItem(int n) throws DecoderException {
        int n2 = this.values[n] & 0xFF;
        DecodeRetValue decodeRetValue = this.decodeItem(n, n2);
        decodeRetValue.syntax = n2;
        return decodeRetValue;
    }

    private final DecodeRetValue decodeLength(int n, int n2) throws DecoderException {
        int n3;
        int n4;
        String string = "decodeLenght";
        DecodeRetValue decodeRetValue = new DecodeRetValue();
        int n5 = this.values[n] & 0xFF;
        if ((n5 & 0x80) != 0) {
            n4 = n5 & 0xFFFFFF7F;
            n3 = SstDecoder.computeIntegerValue(this.values, n + 1, n4);
            ++n4;
        } else {
            n3 = n5;
            n4 = 1;
        }
        decodeRetValue.itemLength = n3;
        decodeRetValue.itemDataLength = n4;
        if (n3 == 0 && n2 != 5 && n2 != 6 && n2 != 4) {
            throw new DecoderException("Zero length item found with invalid syntax " + n2 + " at pos. " + n);
        }
        if (n3 < 0) {
            throw new DecoderException("Negative length found: " + n3 + " at pos. " + n);
        }
        return decodeRetValue;
    }

    private final DecodeRetValue decodeContainment(int n) throws DecoderException {
        DecodeRetValue decodeRetValue = this.decodeItem(n, 48);
        DecodeRetValue decodeRetValue2 = new DecodeRetValue();
        decodeRetValue2.itemLength = decodeRetValue.itemLength;
        decodeRetValue2.nextItemIndex = decodeRetValue.nextItemIndex;
        decodeRetValue = this.decodeItem(decodeRetValue.itemDataIndex, 6);
        String string = SstDecoder.convertAsn1ObjectIdToDecimalString(this.values, decodeRetValue.itemDataIndex, decodeRetValue.itemDataLength);
        this._8250_modTable = false;
        if (string.equals("1.3.6.1.4.1.49.2.3.1.4.1.1")) {
            string = "1.3.6.1.4.1.49.2.3.1.4.6.1";
            this._8250_module_on_8260 = true;
            this._8250_modTable = true;
        }
        if (string.equals("1.3.6.1.4.1.49.2.3.1.4.2.1")) {
            string = "1.3.6.1.4.1.49.2.3.1.4.11.1";
            this._8250_module_on_8260 = true;
        }
        decodeRetValue = this.decodeItem(decodeRetValue.nextItemIndex, 48);
        n = decodeRetValue.itemDataIndex;
        int n2 = decodeRetValue.itemDataLength;
        while (n2 > 0) {
            decodeRetValue = this.decodeBlock(n, string);
            n2 -= decodeRetValue.itemLength;
            n = decodeRetValue.nextItemIndex;
        }
        this._8250_module_on_8260 = false;
        return decodeRetValue2;
    }

    private final DecodeRetValue decodeBlock(int n, String string) throws DecoderException {
        DecodeRetValue decodeRetValue = this.decodeItem(n, 48);
        DecodeRetValue decodeRetValue2 = new DecodeRetValue();
        decodeRetValue2.itemLength = decodeRetValue.itemLength;
        decodeRetValue2.nextItemIndex = decodeRetValue.nextItemIndex;
        n = decodeRetValue.itemDataIndex;
        decodeRetValue = this.decodeSuffix(n);
        String string2 = decodeRetValue.suffix;
        n = decodeRetValue.nextItemIndex;
        decodeRetValue = this.decodeItem(n, 48);
        n = decodeRetValue.itemDataIndex;
        int n2 = decodeRetValue.itemDataLength;
        if (this._8250_module_on_8260) {
            this.mibInfo.addVar(String.valueOf(string) + ".0", new MibValue(string2, new Integer(1)));
        }
        while (n2 > 0) {
            decodeRetValue = this.decodeValue(n, string, string2);
            n2 -= decodeRetValue.itemLength;
            n = decodeRetValue.nextItemIndex;
        }
        return decodeRetValue2;
    }

    static boolean isDisplayString(OctetString octetString) {
        int n = 0;
        while (n < octetString.value.length) {
            if (octetString.value[n] < 32 || octetString.value[n] > 127) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final DecodeRetValue decodeValue(int n, String string, String string2) throws DecoderException {
        String string3 = "decodeValue";
        DecodeRetValue decodeRetValue = this.decodeItem(n, 48);
        DecodeRetValue decodeRetValue2 = new DecodeRetValue();
        decodeRetValue2.nextItemIndex = decodeRetValue.nextItemIndex;
        decodeRetValue2.itemLength = decodeRetValue.itemLength;
        n = decodeRetValue.itemDataIndex;
        decodeRetValue = this.decodeItem(n, 2);
        int n2 = this._8250_module_on_8260 ? 1 : 0;
        int n3 = SstDecoder.computeIntegerValue(this.values, decodeRetValue.itemDataIndex, decodeRetValue.itemDataLength);
        if (this._8250_module_on_8260 && n3 > 14) {
            ++n2;
        }
        decodeRetValue2.suffix = String.valueOf(n3 + n2);
        String string4 = String.valueOf(string) + "." + decodeRetValue2.suffix;
        n = decodeRetValue.nextItemIndex;
        decodeRetValue = this.decodeItem(n);
        Object object = "null";
        switch (decodeRetValue.syntax) {
            case 2: {
                int n4 = SstDecoder.computeIntegerValue(this.values, decodeRetValue.itemDataIndex, decodeRetValue.itemDataLength);
                object = new Integer(n4);
                this.mibInfo.addVar(string4, new MibValue(string2, (Serializable)object));
                break;
            }
            case 64: {
                int n5 = 0;
                n = decodeRetValue.itemDataIndex;
                int n6 = 0;
                while (n6 < decodeRetValue.itemDataLength) {
                    n5 = n5 << 8 | this.values[n++] & 0xFF;
                    ++n6;
                }
                object = new IPAddress(n5);
                this.mibInfo.addVar(string4, new MibValue(string2, (Serializable)object));
                break;
            }
            case 4: {
                byte[] byArray = new byte[decodeRetValue.itemDataLength];
                n = decodeRetValue.itemDataIndex;
                int n7 = 0;
                while (n7 < decodeRetValue.itemDataLength) {
                    byArray[n7] = this.values[n++];
                    ++n7;
                }
                object = new OctetString(byArray);
                Object v = mappingTable.get(string4);
                if (v != null) {
                    if (v == IP_STR) {
                        object = new IPAddress(((OctetString)object).value, 0);
                    } else if (v == DS_STR) {
                        object = ((OctetString)object).toDisplayString();
                    }
                }
                this.mibInfo.addVar(string4, new MibValue(string2, (Serializable)object));
                break;
            }
            default: {
                throw new DecoderException("Unknown syntax for attribute value: Oid = " + string + "." + decodeRetValue2.suffix + " syntax = " + decodeRetValue.syntax + " suffix = " + string2 + " at pos. " + n);
            }
        }
        if (RAS.isEnabled(19, 28)) {
            OctetString octetString;
            RAS.trace(19, 28, this, string3, "Full OID -> " + string4);
            RAS.trace(19, 28, this, string3, "Syntax   -> " + decodeRetValue.syntax);
            String string5 = object.toString();
            if (object instanceof OctetString && SstDecoder.isDisplayString(octetString = (OctetString)object)) {
                string5 = octetString.toDisplayString();
            }
            RAS.trace(19, 28, this, string3, "Value    -> " + string5);
        }
        return decodeRetValue2;
    }

    private final DecodeRetValue decodeSuffix(int n) throws DecoderException {
        String string = "decodeSuffix";
        DecodeRetValue decodeRetValue = new DecodeRetValue();
        DecodeRetValue decodeRetValue2 = this.decodeItem(n);
        decodeRetValue.nextItemIndex = decodeRetValue2.nextItemIndex;
        decodeRetValue.itemLength = decodeRetValue2.itemLength;
        switch (decodeRetValue2.syntax) {
            case 5: {
                decodeRetValue.suffix = ".0";
                decodeRetValue.numberIndexes = 1;
                break;
            }
            case 48: {
                n = decodeRetValue2.itemDataIndex;
                int n2 = decodeRetValue2.itemDataLength;
                while (n2 > 0) {
                    decodeRetValue2 = this.decodeItem(n, 2);
                    n2 -= decodeRetValue2.itemLength;
                    n = decodeRetValue2.nextItemIndex;
                    ++decodeRetValue.numberIndexes;
                    decodeRetValue.suffix = String.valueOf(decodeRetValue.suffix) + "." + SstDecoder.computeIntegerValue(this.values, decodeRetValue2.itemDataIndex, decodeRetValue2.itemDataLength);
                    if (!this._8250_module_on_8260 || decodeRetValue.numberIndexes != 1) continue;
                    decodeRetValue.suffix = String.valueOf(decodeRetValue.suffix) + ".1";
                }
                break;
            }
            default: {
                throw new DecoderException("Suffix with unsupported syntax: " + decodeRetValue2.syntax + " at pos. " + n);
            }
        }
        if (RAS.isEnabled(19, 28)) {
            RAS.trace(19, 28, this, string, "Suffix-> " + decodeRetValue.suffix);
        }
        return decodeRetValue;
    }

    public static final int computeIntegerValue(byte[] byArray, int n, int n2) {
        int n3 = 0;
        n2 += n;
        int n4 = n;
        while (n4 < n2) {
            n3 = n3 << 8 | byArray[n4] & 0xFF;
            ++n4;
        }
        return n3;
    }

    public static final String convertAsn1ObjectIdToDecimalString(byte[] byArray, int n, int n2) {
        String string = "converAsn1ObjectIdToDecimalString";
        int n3 = byArray[n] & 0xFF;
        ++n;
        String string2 = String.valueOf(n3 / 40) + "." + n3 % 40;
        int n4 = 1;
        int n5 = 0;
        while (n4 < n2) {
            n5 = 0;
            n3 = byArray[n] & 0xFF;
            while ((n3 & 0x80) != 0) {
                n5 = n5 << 7 | (n3 &= 0xFFFFFF7F) & 0xFF;
                ++n4;
                n3 = byArray[++n] & 0xFF;
            }
            n5 = n5 << 7 | n3 & 0xFF;
            string2 = String.valueOf(string2) + "." + n5;
            ++n4;
            ++n;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String[][] stringArrayArray = new String[][]{{"1.3.6.1.4.1.49.2.3.1.4.6.1.5", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.7", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.8", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.18", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.22", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.23", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.161.6.1.7", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.161.6.1.8", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.161.6.1.18", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.161.6.1.22", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.161.6.1.23", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.166.6.1.7", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.166.6.1.8", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.166.6.1.18", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.166.6.1.22", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.166.6.1.23", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.167.6.1.7", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.167.6.1.8", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.167.6.1.18", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.167.6.1.22", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.167.6.1.23", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.177.6.1.7", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.177.6.1.8", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.177.6.1.18", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.177.6.1.22", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.177.6.1.23", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.180.6.1.7", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.180.6.1.8", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.180.6.1.18", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.180.6.1.22", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.180.6.1.23", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.181.6.1.7", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.181.6.1.8", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.181.6.1.18", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.181.6.1.22", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.181.6.1.23", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.21.1.1.3", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.25.1.1.5", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.4", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.45.6.1.4", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.4", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.62.1.1.6", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.97.11.1.4", IP_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.63.1.1.2", DS_STR}, {"1.3.6.1.4.1.49.2.3.1.4.4.64.1.1.2", DS_STR}};
        int n = 0;
        while (n < stringArrayArray.length) {
            mappingTable.put(stringArrayArray[n][0], stringArrayArray[n][1]);
            ++n;
        }
    }

    private class DecodeRetValue {
        public int itemLength;
        public int itemDataLength;
        public int itemDataIndex;
        public int nextItemIndex;
        public String suffix = "";
        public int numberIndexes;
        public int syntax = 0;

        public final String toString() {
            return "il = " + this.itemLength + " idl = " + this.itemDataLength + " idi = " + this.itemDataIndex + " nii = " + this.nextItemIndex + " suf = " + this.suffix + " nind = " + this.numberIndexes + " syn = " + this.syntax;
        }

        DecodeRetValue() {
            SstDecoder.this = SstDecoder.this;
        }
    }
}

